package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchReadSuccessfulResponse(
    listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse
    ] = None,
    listObjectChildren: Option[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse
    ] = None,
    getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse
    ] = None,
    getObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse
    ] = None,
    listAttachedIndices: Option[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse
    ] = None,
    listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse
    ] = None,
    listObjectPolicies: Option[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse
    ] = None,
    listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse
    ] = None,
    lookupPolicy: Option[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse
    ] = None,
    listIndex: Option[zio.aws.clouddirectory.model.BatchListIndexResponse] =
      None,
    listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse
    ] = None,
    listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse
    ] = None,
    getLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse
    ] = None,
    listObjectParents: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse = {
    import BatchReadSuccessfulResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
      .builder()
      .optionallyWith(listObjectAttributes.map(value => value.buildAwsValue()))(
        _.listObjectAttributes
      )
      .optionallyWith(listObjectChildren.map(value => value.buildAwsValue()))(
        _.listObjectChildren
      )
      .optionallyWith(getObjectInformation.map(value => value.buildAwsValue()))(
        _.getObjectInformation
      )
      .optionallyWith(getObjectAttributes.map(value => value.buildAwsValue()))(
        _.getObjectAttributes
      )
      .optionallyWith(listAttachedIndices.map(value => value.buildAwsValue()))(
        _.listAttachedIndices
      )
      .optionallyWith(
        listObjectParentPaths.map(value => value.buildAwsValue())
      )(_.listObjectParentPaths)
      .optionallyWith(listObjectPolicies.map(value => value.buildAwsValue()))(
        _.listObjectPolicies
      )
      .optionallyWith(
        listPolicyAttachments.map(value => value.buildAwsValue())
      )(_.listPolicyAttachments)
      .optionallyWith(lookupPolicy.map(value => value.buildAwsValue()))(
        _.lookupPolicy
      )
      .optionallyWith(listIndex.map(value => value.buildAwsValue()))(
        _.listIndex
      )
      .optionallyWith(
        listOutgoingTypedLinks.map(value => value.buildAwsValue())
      )(_.listOutgoingTypedLinks)
      .optionallyWith(
        listIncomingTypedLinks.map(value => value.buildAwsValue())
      )(_.listIncomingTypedLinks)
      .optionallyWith(getLinkAttributes.map(value => value.buildAwsValue()))(
        _.getLinkAttributes
      )
      .optionallyWith(listObjectParents.map(value => value.buildAwsValue()))(
        _.listObjectParents
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadSuccessfulResponse
      .wrap(buildAwsValue())
}
object BatchReadSuccessfulResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadSuccessfulResponse =
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse(
        listObjectAttributes.map(value => value.asEditable),
        listObjectChildren.map(value => value.asEditable),
        getObjectInformation.map(value => value.asEditable),
        getObjectAttributes.map(value => value.asEditable),
        listAttachedIndices.map(value => value.asEditable),
        listObjectParentPaths.map(value => value.asEditable),
        listObjectPolicies.map(value => value.asEditable),
        listPolicyAttachments.map(value => value.asEditable),
        lookupPolicy.map(value => value.asEditable),
        listIndex.map(value => value.asEditable),
        listOutgoingTypedLinks.map(value => value.asEditable),
        listIncomingTypedLinks.map(value => value.asEditable),
        getLinkAttributes.map(value => value.asEditable),
        listObjectParents.map(value => value.asEditable)
      )
    def listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ]
    def listObjectChildren: Option[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ]
    def getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ]
    def getObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ]
    def listAttachedIndices: Option[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ]
    def listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ]
    def listObjectPolicies: Option[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ]
    def listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ]
    def lookupPolicy: Option[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ]
    def listIndex
        : Option[zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly]
    def listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ]
    def listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ]
    def getLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ]
    def listObjectParents: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ]
    def getListObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectAttributes", listObjectAttributes)
    def getListObjectChildren: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectChildren", listObjectChildren)
    def getGetObjectInformation: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectInformation", getObjectInformation)
    def getGetObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectAttributes", getObjectAttributes)
    def getListAttachedIndices: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listAttachedIndices", listAttachedIndices)
    def getListObjectParentPaths: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("listObjectParentPaths", listObjectParentPaths)
    def getListObjectPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectPolicies", listObjectPolicies)
    def getListPolicyAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("listPolicyAttachments", listPolicyAttachments)
    def getLookupPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("lookupPolicy", lookupPolicy)
    def getListIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listIndex", listIndex)
    def getListOutgoingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listOutgoingTypedLinks",
      listOutgoingTypedLinks
    )
    def getListIncomingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listIncomingTypedLinks",
      listIncomingTypedLinks
    )
    def getGetLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("getLinkAttributes", getLinkAttributes)
    def getListObjectParents: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectParents", listObjectParents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ) extends zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly {
    override val listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributesResponse.ReadOnly
    ] = scala
      .Option(impl.listObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectAttributesResponse
          .wrap(value)
      )
    override val listObjectChildren: Option[
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly
    ] = scala
      .Option(impl.listObjectChildren())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.wrap(value)
      )
    override val getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformationResponse.ReadOnly
    ] = scala
      .Option(impl.getObjectInformation())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectInformationResponse
          .wrap(value)
      )
    override val getObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly
    ] = scala
      .Option(impl.getObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse
          .wrap(value)
      )
    override val listAttachedIndices: Option[
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly
    ] = scala
      .Option(impl.listAttachedIndices())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse
          .wrap(value)
      )
    override val listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly
    ] = scala
      .Option(impl.listObjectParentPaths())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse
          .wrap(value)
      )
    override val listObjectPolicies: Option[
      zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.ReadOnly
    ] = scala
      .Option(impl.listObjectPolicies())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectPoliciesResponse.wrap(value)
      )
    override val listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse.ReadOnly
    ] = scala
      .Option(impl.listPolicyAttachments())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListPolicyAttachmentsResponse
          .wrap(value)
      )
    override val lookupPolicy: Option[
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly
    ] = scala
      .Option(impl.lookupPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchLookupPolicyResponse.wrap(value)
      )
    override val listIndex
        : Option[zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly] =
      scala
        .Option(impl.listIndex())
        .map(value =>
          zio.aws.clouddirectory.model.BatchListIndexResponse.wrap(value)
        )
    override val listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly
    ] = scala
      .Option(impl.listOutgoingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse
          .wrap(value)
      )
    override val listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly
    ] = scala
      .Option(impl.listIncomingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse
          .wrap(value)
      )
    override val getLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.ReadOnly
    ] = scala
      .Option(impl.getLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetLinkAttributesResponse.wrap(value)
      )
    override val listObjectParents: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentsResponse.ReadOnly
    ] = scala
      .Option(impl.listObjectParents())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentsResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadSuccessfulResponse
  ): zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly =
    new Wrapper(impl)
}
