package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{ObjectIdentifier, PathString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PathToObjectIdentifiers(
    path: Option[PathString] = None,
    objectIdentifiers: Option[Iterable[ObjectIdentifier]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers = {
    import PathToObjectIdentifiers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers
      .builder()
      .optionallyWith(
        path.map(value => PathString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        objectIdentifiers.map(value =>
          value.map { item =>
            ObjectIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.objectIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly =
    zio.aws.clouddirectory.model.PathToObjectIdentifiers.wrap(buildAwsValue())
}
object PathToObjectIdentifiers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PathToObjectIdentifiers =
      zio.aws.clouddirectory.model.PathToObjectIdentifiers(
        path.map(value => value),
        objectIdentifiers.map(value => value)
      )
    def path: Option[PathString]
    def objectIdentifiers: Option[List[ObjectIdentifier]]
    def getPath: ZIO[Any, AwsError, PathString] =
      AwsError.unwrapOptionField("path", path)
    def getObjectIdentifiers: ZIO[Any, AwsError, List[ObjectIdentifier]] =
      AwsError.unwrapOptionField("objectIdentifiers", objectIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers
  ) extends zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly {
    override val path: Option[PathString] = scala
      .Option(impl.path())
      .map(value => zio.aws.clouddirectory.model.primitives.PathString(value))
    override val objectIdentifiers: Option[List[ObjectIdentifier]] = scala
      .Option(impl.objectIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers
  ): zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly =
    new Wrapper(impl)
}
