package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.clouddirectory.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.TagResourceRequest.ReadOnly =
    zio.aws.clouddirectory.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TagResourceRequest =
      zio.aws.clouddirectory.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.clouddirectory.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.clouddirectory.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest
  ) extends zio.aws.clouddirectory.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.clouddirectory.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest
  ): zio.aws.clouddirectory.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
