package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchAttachObjectResponse(
    attachedObjectIdentifier: Option[ObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse = {
    import BatchAttachObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse
      .builder()
      .optionallyWith(
        attachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.attachedObjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachObjectResponse.wrap(buildAwsValue())
}
object BatchAttachObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachObjectResponse =
      zio.aws.clouddirectory.model
        .BatchAttachObjectResponse(attachedObjectIdentifier.map(value => value))
    def attachedObjectIdentifier: Option[ObjectIdentifier]
    def getAttachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "attachedObjectIdentifier",
        attachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse
  ) extends zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly {
    override val attachedObjectIdentifier: Option[ObjectIdentifier] = scala
      .Option(impl.attachedObjectIdentifier())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse
  ): zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly =
    new Wrapper(impl)
}
