package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachObjectResponse(
    attachedObjectIdentifier: Option[ObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse = {
    import AttachObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse
      .builder()
      .optionallyWith(
        attachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.attachedObjectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly =
    zio.aws.clouddirectory.model.AttachObjectResponse.wrap(buildAwsValue())
}
object AttachObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachObjectResponse =
      zio.aws.clouddirectory.model
        .AttachObjectResponse(attachedObjectIdentifier.map(value => value))
    def attachedObjectIdentifier: Option[ObjectIdentifier]
    def getAttachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "attachedObjectIdentifier",
        attachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse
  ) extends zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly {
    override val attachedObjectIdentifier: Option[ObjectIdentifier] = scala
      .Option(impl.attachedObjectIdentifier())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse
  ): zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
