package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteObject(
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject = {
    import BatchDeleteObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchDeleteObject.wrap(buildAwsValue())
}
object BatchDeleteObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDeleteObject =
      zio.aws.clouddirectory.model.BatchDeleteObject(objectReference.asEditable)
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject
  ) extends zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject
  ): zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly = new Wrapper(impl)
}
