package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpgradePublishedSchemaResponse(
    upgradedSchemaArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse = {
    import UpgradePublishedSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse
      .builder()
      .optionallyWith(
        upgradedSchemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.upgradedSchemaArn)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse
      .wrap(buildAwsValue())
}
object UpgradePublishedSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse =
      zio.aws.clouddirectory.model
        .UpgradePublishedSchemaResponse(upgradedSchemaArn.map(value => value))
    def upgradedSchemaArn: Option[Arn]
    def getUpgradedSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("upgradedSchemaArn", upgradedSchemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse
  ) extends zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly {
    override val upgradedSchemaArn: Option[Arn] = scala
      .Option(impl.upgradedSchemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse
  ): zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly =
    new Wrapper(impl)
}
