package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateLinkAttributesRequest(
    directoryArn: Arn,
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier,
    attributeUpdates: Iterable[zio.aws.clouddirectory.model.LinkAttributeUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest = {
    import UpdateLinkAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .attributeUpdates(attributeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpdateLinkAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpdateLinkAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateLinkAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpdateLinkAttributesRequest =
      zio.aws.clouddirectory.model.UpdateLinkAttributesRequest(
        directoryArn,
        typedLinkSpecifier.asEditable,
        attributeUpdates.map { item =>
          item.asEditable
        }
      )
    def directoryArn: Arn
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def attributeUpdates
        : List[zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
    def getAttributeUpdates: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly
    ]] = ZIO.succeed(attributeUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest
  ) extends zio.aws.clouddirectory.model.UpdateLinkAttributesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
    override val attributeUpdates
        : List[zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly] = impl
      .attributeUpdates()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.LinkAttributeUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest
  ): zio.aws.clouddirectory.model.UpdateLinkAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
