package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListManagedSchemaArnsRequest(
    schemaArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest = {
    import ListManagedSchemaArnsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest
      .wrap(buildAwsValue())
}
object ListManagedSchemaArnsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest =
      zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest(
        schemaArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def schemaArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ) extends zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly {
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ): zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly =
    new Wrapper(impl)
}
