package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchWriteResponse(
    responses: Option[
      Iterable[zio.aws.clouddirectory.model.BatchWriteOperationResponse]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse = {
    import BatchWriteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteResponse.wrap(buildAwsValue())
}
object BatchWriteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteResponse =
      zio.aws.clouddirectory.model.BatchWriteResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses: Option[
      List[zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly]
    ]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse
  ) extends zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly {
    override val responses: Option[
      List[zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly]
    ] = scala
      .Option(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.BatchWriteOperationResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse
  ): zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly = new Wrapper(
    impl
  )
}
