package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachTypedLinkRequest(
    directoryArn: Arn,
    sourceObjectReference: zio.aws.clouddirectory.model.ObjectReference,
    targetObjectReference: zio.aws.clouddirectory.model.ObjectReference,
    typedLinkFacet: zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName,
    attributes: Iterable[zio.aws.clouddirectory.model.AttributeNameAndValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest = {
    import AttachTypedLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .sourceObjectReference(sourceObjectReference.buildAwsValue())
      .targetObjectReference(targetObjectReference.buildAwsValue())
      .typedLinkFacet(typedLinkFacet.buildAwsValue())
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachTypedLinkRequest.ReadOnly =
    zio.aws.clouddirectory.model.AttachTypedLinkRequest.wrap(buildAwsValue())
}
object AttachTypedLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachTypedLinkRequest =
      zio.aws.clouddirectory.model.AttachTypedLinkRequest(
        directoryArn,
        sourceObjectReference.asEditable,
        targetObjectReference.asEditable,
        typedLinkFacet.asEditable,
        attributes.map { item =>
          item.asEditable
        }
      )
    def directoryArn: Arn
    def sourceObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def targetObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def typedLinkFacet
        : zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    def attributes
        : List[zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getSourceObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(sourceObjectReference)
    def getTargetObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetObjectReference)
    def getTypedLinkFacet: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    ] = ZIO.succeed(typedLinkFacet)
    def getAttributes: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly
    ]] = ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest
  ) extends zio.aws.clouddirectory.model.AttachTypedLinkRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val sourceObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference
        .wrap(impl.sourceObjectReference())
    override val targetObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference
        .wrap(impl.targetObjectReference())
    override val typedLinkFacet
        : zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName
        .wrap(impl.typedLinkFacet())
    override val attributes
        : List[zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly] =
      impl
        .attributes()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.AttributeNameAndValue.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest
  ): zio.aws.clouddirectory.model.AttachTypedLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
