package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TypedAttributeValueRange(
    startMode: zio.aws.clouddirectory.model.RangeMode,
    startValue: Option[zio.aws.clouddirectory.model.TypedAttributeValue] = None,
    endMode: zio.aws.clouddirectory.model.RangeMode,
    endValue: Option[zio.aws.clouddirectory.model.TypedAttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange = {
    import TypedAttributeValueRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange
      .builder()
      .startMode(startMode.unwrap)
      .optionallyWith(startValue.map(value => value.buildAwsValue()))(
        _.startValue
      )
      .endMode(endMode.unwrap)
      .optionallyWith(endValue.map(value => value.buildAwsValue()))(_.endValue)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly =
    zio.aws.clouddirectory.model.TypedAttributeValueRange.wrap(buildAwsValue())
}
object TypedAttributeValueRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedAttributeValueRange =
      zio.aws.clouddirectory.model.TypedAttributeValueRange(
        startMode,
        startValue.map(value => value.asEditable),
        endMode,
        endValue.map(value => value.asEditable)
      )
    def startMode: zio.aws.clouddirectory.model.RangeMode
    def startValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def endMode: zio.aws.clouddirectory.model.RangeMode
    def endValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def getStartMode
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.RangeMode] =
      ZIO.succeed(startMode)
    def getStartValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("startValue", startValue)
    def getEndMode: ZIO[Any, Nothing, zio.aws.clouddirectory.model.RangeMode] =
      ZIO.succeed(endMode)
    def getEndValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("endValue", endValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange
  ) extends zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly {
    override val startMode: zio.aws.clouddirectory.model.RangeMode =
      zio.aws.clouddirectory.model.RangeMode.wrap(impl.startMode())
    override val startValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      scala
        .Option(impl.startValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
    override val endMode: zio.aws.clouddirectory.model.RangeMode =
      zio.aws.clouddirectory.model.RangeMode.wrap(impl.endMode())
    override val endValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      scala
        .Option(impl.endValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange
  ): zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly =
    new Wrapper(impl)
}
