package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{FacetName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SchemaFacet(
    schemaArn: Option[Arn] = None,
    facetName: Option[FacetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.SchemaFacet = {
    import SchemaFacet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.SchemaFacet
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        facetName.map(value => FacetName.unwrap(value): java.lang.String)
      )(_.facetName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
    zio.aws.clouddirectory.model.SchemaFacet.wrap(buildAwsValue())
}
object SchemaFacet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.SchemaFacet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.SchemaFacet =
      zio.aws.clouddirectory.model.SchemaFacet(
        schemaArn.map(value => value),
        facetName.map(value => value)
      )
    def schemaArn: Option[Arn]
    def facetName: Option[FacetName]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getFacetName: ZIO[Any, AwsError, FacetName] =
      AwsError.unwrapOptionField("facetName", facetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.SchemaFacet
  ) extends zio.aws.clouddirectory.model.SchemaFacet.ReadOnly {
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val facetName: Option[FacetName] = scala
      .Option(impl.facetName())
      .map(value => zio.aws.clouddirectory.model.primitives.FacetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.SchemaFacet
  ): zio.aws.clouddirectory.model.SchemaFacet.ReadOnly = new Wrapper(impl)
}
