package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchAttachTypedLinkResponse(
    typedLinkSpecifier: Option[
      zio.aws.clouddirectory.model.TypedLinkSpecifier
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse = {
    import BatchAttachTypedLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse
      .builder()
      .optionallyWith(typedLinkSpecifier.map(value => value.buildAwsValue()))(
        _.typedLinkSpecifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse
      .wrap(buildAwsValue())
}
object BatchAttachTypedLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse =
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse(
        typedLinkSpecifier.map(value => value.asEditable)
      )
    def typedLinkSpecifier
        : Option[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    def getTypedLinkSpecifier: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = AwsError.unwrapOptionField("typedLinkSpecifier", typedLinkSpecifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse
  ) extends zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly {
    override val typedLinkSpecifier
        : Option[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly] =
      scala
        .Option(impl.typedLinkSpecifier())
        .map(value =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse
  ): zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly =
    new Wrapper(impl)
}
