package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.SelectorObjectReference
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectReference(
    selector: Option[SelectorObjectReference] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectReference = {
    import ObjectReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectReference
      .builder()
      .optionallyWith(
        selector.map(value =>
          SelectorObjectReference.unwrap(value): java.lang.String
        )
      )(_.selector)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
    zio.aws.clouddirectory.model.ObjectReference.wrap(buildAwsValue())
}
object ObjectReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ObjectReference =
      zio.aws.clouddirectory.model.ObjectReference(selector.map(value => value))
    def selector: Option[SelectorObjectReference]
    def getSelector: ZIO[Any, AwsError, SelectorObjectReference] =
      AwsError.unwrapOptionField("selector", selector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectReference
  ) extends zio.aws.clouddirectory.model.ObjectReference.ReadOnly {
    override val selector: Option[SelectorObjectReference] = scala
      .Option(impl.selector())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.SelectorObjectReference(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectReference
  ): zio.aws.clouddirectory.model.ObjectReference.ReadOnly = new Wrapper(impl)
}
