package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchGetObjectAttributesResponse(
    attributes: Option[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributesResponse = {
    import BatchGetObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse
      .wrap(buildAwsValue())
}
object BatchGetObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse =
      zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributesResponse
  ) extends zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly {
    override val attributes: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributesResponse
  ): zio.aws.clouddirectory.model.BatchGetObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
