package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchAddFacetToObject(
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    objectAttributeList: Iterable[
      zio.aws.clouddirectory.model.AttributeKeyAndValue
    ],
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject = {
    import BatchAddFacetToObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject
      .builder()
      .schemaFacet(schemaFacet.buildAwsValue())
      .objectAttributeList(objectAttributeList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchAddFacetToObject.wrap(buildAwsValue())
}
object BatchAddFacetToObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAddFacetToObject =
      zio.aws.clouddirectory.model.BatchAddFacetToObject(
        schemaFacet.asEditable,
        objectAttributeList.map { item =>
          item.asEditable
        },
        objectReference.asEditable
      )
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def objectAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getObjectAttributeList: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = ZIO.succeed(objectAttributeList)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject
  ) extends zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly {
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val objectAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly] =
      impl
        .objectAttributeList()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }
        .toList
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject
  ): zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly = new Wrapper(
    impl
  )
}
