package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TypedLinkAttributeRange(
    attributeName: Option[AttributeName] = None,
    range: zio.aws.clouddirectory.model.TypedAttributeValueRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange = {
    import TypedLinkAttributeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          AttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .range(range.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkAttributeRange.wrap(buildAwsValue())
}
object TypedLinkAttributeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkAttributeRange =
      zio.aws.clouddirectory.model.TypedLinkAttributeRange(
        attributeName.map(value => value),
        range.asEditable
      )
    def attributeName: Option[AttributeName]
    def range: zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    def getAttributeName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getRange: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ] = ZIO.succeed(range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange
  ) extends zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly {
    override val attributeName: Option[AttributeName] = scala
      .Option(impl.attributeName())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.AttributeName(value)
      )
    override val range
        : zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly =
      zio.aws.clouddirectory.model.TypedAttributeValueRange.wrap(impl.range())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange
  ): zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly =
    new Wrapper(impl)
}
