package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAppliedSchemaArnsResponse(
    schemaArns: Option[Iterable[Arn]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse = {
    import ListAppliedSchemaArnsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse
      .builder()
      .optionallyWith(
        schemaArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.schemaArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse
      .wrap(buildAwsValue())
}
object ListAppliedSchemaArnsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse =
      zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse(
        schemaArns.map(value => value),
        nextToken.map(value => value)
      )
    def schemaArns: Option[List[Arn]]
    def nextToken: Option[NextToken]
    def getSchemaArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("schemaArns", schemaArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse
  ) extends zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly {
    override val schemaArns: Option[List[Arn]] = scala
      .Option(impl.schemaArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.Arn(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse
  ): zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly =
    new Wrapper(impl)
}
