package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FacetAttributeUpdate(
    attribute: Option[zio.aws.clouddirectory.model.FacetAttribute] = None,
    action: Option[zio.aws.clouddirectory.model.UpdateActionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate = {
    import FacetAttributeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
      .builder()
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly =
    zio.aws.clouddirectory.model.FacetAttributeUpdate.wrap(buildAwsValue())
}
object FacetAttributeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.FacetAttributeUpdate =
      zio.aws.clouddirectory.model.FacetAttributeUpdate(
        attribute.map(value => value.asEditable),
        action.map(value => value)
      )
    def attribute: Option[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]
    def action: Option[zio.aws.clouddirectory.model.UpdateActionType]
    def getAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("attribute", attribute)
    def getAction
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.UpdateActionType] =
      AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ) extends zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly {
    override val attribute
        : Option[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly] = scala
      .Option(impl.attribute())
      .map(value => zio.aws.clouddirectory.model.FacetAttribute.wrap(value))
    override val action: Option[zio.aws.clouddirectory.model.UpdateActionType] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.clouddirectory.model.UpdateActionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate
  ): zio.aws.clouddirectory.model.FacetAttributeUpdate.ReadOnly = new Wrapper(
    impl
  )
}
