package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchRemoveFacetFromObject(
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject = {
    import BatchRemoveFacetFromObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject
      .builder()
      .schemaFacet(schemaFacet.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchRemoveFacetFromObject
      .wrap(buildAwsValue())
}
object BatchRemoveFacetFromObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchRemoveFacetFromObject =
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject(
        schemaFacet.asEditable,
        objectReference.asEditable
      )
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject
  ) extends zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly {
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject
  ): zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly =
    new Wrapper(impl)
}
