package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  BatchReferenceName,
  LinkName,
  Bool
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchCreateIndex(
    orderedIndexedAttributeList: Iterable[
      zio.aws.clouddirectory.model.AttributeKey
    ],
    isUnique: Bool,
    parentReference: Option[zio.aws.clouddirectory.model.ObjectReference] =
      None,
    linkName: Option[LinkName] = None,
    batchReferenceName: Option[BatchReferenceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex = {
    import BatchCreateIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex
      .builder()
      .orderedIndexedAttributeList(orderedIndexedAttributeList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isUnique(Bool.unwrap(isUnique): java.lang.Boolean)
      .optionallyWith(parentReference.map(value => value.buildAwsValue()))(
        _.parentReference
      )
      .optionallyWith(
        linkName.map(value => LinkName.unwrap(value): java.lang.String)
      )(_.linkName)
      .optionallyWith(
        batchReferenceName.map(value =>
          BatchReferenceName.unwrap(value): java.lang.String
        )
      )(_.batchReferenceName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly =
    zio.aws.clouddirectory.model.BatchCreateIndex.wrap(buildAwsValue())
}
object BatchCreateIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchCreateIndex =
      zio.aws.clouddirectory.model.BatchCreateIndex(
        orderedIndexedAttributeList.map { item =>
          item.asEditable
        },
        isUnique,
        parentReference.map(value => value.asEditable),
        linkName.map(value => value),
        batchReferenceName.map(value => value)
      )
    def orderedIndexedAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def isUnique: Bool
    def parentReference
        : Option[zio.aws.clouddirectory.model.ObjectReference.ReadOnly]
    def linkName: Option[LinkName]
    def batchReferenceName: Option[BatchReferenceName]
    def getOrderedIndexedAttributeList: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ]] = ZIO.succeed(orderedIndexedAttributeList)
    def getIsUnique: ZIO[Any, Nothing, Bool] = ZIO.succeed(isUnique)
    def getParentReference: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = AwsError.unwrapOptionField("parentReference", parentReference)
    def getLinkName: ZIO[Any, AwsError, LinkName] =
      AwsError.unwrapOptionField("linkName", linkName)
    def getBatchReferenceName: ZIO[Any, AwsError, BatchReferenceName] =
      AwsError.unwrapOptionField("batchReferenceName", batchReferenceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex
  ) extends zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly {
    override val orderedIndexedAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] = impl
      .orderedIndexedAttributeList()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.AttributeKey.wrap(item)
      }
      .toList
    override val isUnique: Bool =
      zio.aws.clouddirectory.model.primitives.Bool(impl.isUnique())
    override val parentReference
        : Option[zio.aws.clouddirectory.model.ObjectReference.ReadOnly] = scala
      .Option(impl.parentReference())
      .map(value => zio.aws.clouddirectory.model.ObjectReference.wrap(value))
    override val linkName: Option[LinkName] = scala
      .Option(impl.linkName())
      .map(value => zio.aws.clouddirectory.model.primitives.LinkName(value))
    override val batchReferenceName: Option[BatchReferenceName] = scala
      .Option(impl.batchReferenceName())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.BatchReferenceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex
  ): zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly = new Wrapper(impl)
}
