package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachTypedLinkResponse(
    typedLinkSpecifier: Option[
      zio.aws.clouddirectory.model.TypedLinkSpecifier
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse = {
    import AttachTypedLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse
      .builder()
      .optionallyWith(typedLinkSpecifier.map(value => value.buildAwsValue()))(
        _.typedLinkSpecifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly =
    zio.aws.clouddirectory.model.AttachTypedLinkResponse.wrap(buildAwsValue())
}
object AttachTypedLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachTypedLinkResponse =
      zio.aws.clouddirectory.model.AttachTypedLinkResponse(
        typedLinkSpecifier.map(value => value.asEditable)
      )
    def typedLinkSpecifier
        : Option[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    def getTypedLinkSpecifier: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = AwsError.unwrapOptionField("typedLinkSpecifier", typedLinkSpecifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse
  ) extends zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly {
    override val typedLinkSpecifier
        : Option[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly] =
      scala
        .Option(impl.typedLinkSpecifier())
        .map(value =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse
  ): zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly =
    new Wrapper(impl)
}
