package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIndexResponse(
    indexAttachments: Option[
      Iterable[zio.aws.clouddirectory.model.IndexAttachment]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse = {
    import ListIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse
      .builder()
      .optionallyWith(
        indexAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexAttachments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListIndexResponse.wrap(buildAwsValue())
}
object ListIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListIndexResponse =
      zio.aws.clouddirectory.model.ListIndexResponse(
        indexAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def indexAttachments
        : Option[List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getIndexAttachments: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("indexAttachments", indexAttachments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse
  ) extends zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly {
    override val indexAttachments
        : Option[List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]] =
      scala
        .Option(impl.indexAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.IndexAttachment.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse
  ): zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly = new Wrapper(impl)
}
