package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteObjectRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DeleteObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteObjectRequest =
      zio.aws.clouddirectory.model
        .DeleteObjectRequest(directoryArn, objectReference.asEditable)
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest
  ) extends zio.aws.clouddirectory.model.DeleteObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest
  ): zio.aws.clouddirectory.model.DeleteObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
