package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{LinkName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateObjectRequest(
    directoryArn: Arn,
    schemaFacets: Iterable[zio.aws.clouddirectory.model.SchemaFacet],
    objectAttributeList: Option[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = None,
    parentReference: Option[zio.aws.clouddirectory.model.ObjectReference] =
      None,
    linkName: Option[LinkName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest = {
    import CreateObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .schemaFacets(schemaFacets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        objectAttributeList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.objectAttributeList)
      .optionallyWith(parentReference.map(value => value.buildAwsValue()))(
        _.parentReference
      )
      .optionallyWith(
        linkName.map(value => LinkName.unwrap(value): java.lang.String)
      )(_.linkName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateObjectRequest.wrap(buildAwsValue())
}
object CreateObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateObjectRequest =
      zio.aws.clouddirectory.model.CreateObjectRequest(
        directoryArn,
        schemaFacets.map { item =>
          item.asEditable
        },
        objectAttributeList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parentReference.map(value => value.asEditable),
        linkName.map(value => value)
      )
    def directoryArn: Arn
    def schemaFacets: List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]
    def objectAttributeList: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def parentReference
        : Option[zio.aws.clouddirectory.model.ObjectReference.ReadOnly]
    def linkName: Option[LinkName]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getSchemaFacets: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    ]] = ZIO.succeed(schemaFacets)
    def getObjectAttributeList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("objectAttributeList", objectAttributeList)
    def getParentReference: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = AwsError.unwrapOptionField("parentReference", parentReference)
    def getLinkName: ZIO[Any, AwsError, LinkName] =
      AwsError.unwrapOptionField("linkName", linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest
  ) extends zio.aws.clouddirectory.model.CreateObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val schemaFacets
        : List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] = impl
      .schemaFacets()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.SchemaFacet.wrap(item)
      }
      .toList
    override val objectAttributeList: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = scala
      .Option(impl.objectAttributeList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
    override val parentReference
        : Option[zio.aws.clouddirectory.model.ObjectReference.ReadOnly] = scala
      .Option(impl.parentReference())
      .map(value => zio.aws.clouddirectory.model.ObjectReference.wrap(value))
    override val linkName: Option[LinkName] = scala
      .Option(impl.linkName())
      .map(value => zio.aws.clouddirectory.model.primitives.LinkName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest
  ): zio.aws.clouddirectory.model.CreateObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
