package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{FacetName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFacetRequest(
    schemaArn: Arn,
    name: FacetName,
    attributes: Option[Iterable[zio.aws.clouddirectory.model.FacetAttribute]] =
      None,
    objectType: Option[zio.aws.clouddirectory.model.ObjectType] = None,
    facetStyle: Option[zio.aws.clouddirectory.model.FacetStyle] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest = {
    import CreateFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(FacetName.unwrap(name): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(objectType.map(value => value.unwrap))(_.objectType)
      .optionallyWith(facetStyle.map(value => value.unwrap))(_.facetStyle)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateFacetRequest.wrap(buildAwsValue())
}
object CreateFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateFacetRequest =
      zio.aws.clouddirectory.model.CreateFacetRequest(
        schemaArn,
        name,
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectType.map(value => value),
        facetStyle.map(value => value)
      )
    def schemaArn: Arn
    def name: FacetName
    def attributes
        : Option[List[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]]
    def objectType: Option[zio.aws.clouddirectory.model.ObjectType]
    def facetStyle: Option[zio.aws.clouddirectory.model.FacetStyle]
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(name)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getObjectType
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ObjectType] =
      AwsError.unwrapOptionField("objectType", objectType)
    def getFacetStyle
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.FacetStyle] =
      AwsError.unwrapOptionField("facetStyle", facetStyle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest
  ) extends zio.aws.clouddirectory.model.CreateFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.name())
    override val attributes
        : Option[List[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]] =
      scala
        .Option(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.FacetAttribute.wrap(item)
          }.toList
        )
    override val objectType: Option[zio.aws.clouddirectory.model.ObjectType] =
      scala
        .Option(impl.objectType())
        .map(value => zio.aws.clouddirectory.model.ObjectType.wrap(value))
    override val facetStyle: Option[zio.aws.clouddirectory.model.FacetStyle] =
      scala
        .Option(impl.facetStyle())
        .map(value => zio.aws.clouddirectory.model.FacetStyle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest
  ): zio.aws.clouddirectory.model.CreateFacetRequest.ReadOnly = new Wrapper(
    impl
  )
}
