package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetLinkAttributes(
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier,
    attributeNames: Iterable[AttributeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes = {
    import BatchGetLinkAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes
      .builder()
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .attributeNames(attributeNames.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly =
    zio.aws.clouddirectory.model.BatchGetLinkAttributes.wrap(buildAwsValue())
}
object BatchGetLinkAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchGetLinkAttributes =
      zio.aws.clouddirectory.model
        .BatchGetLinkAttributes(typedLinkSpecifier.asEditable, attributeNames)
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def attributeNames: List[AttributeName]
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes
  ) extends zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly {
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
    override val attributeNames: List[AttributeName] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetLinkAttributes
  ): zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly = new Wrapper(
    impl
  )
}
