package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchListIncomingTypedLinksResponse(
    linkSpecifiers: Option[
      Iterable[zio.aws.clouddirectory.model.TypedLinkSpecifier]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse = {
    import BatchListIncomingTypedLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse
      .builder()
      .optionallyWith(
        linkSpecifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.linkSpecifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse
      .wrap(buildAwsValue())
}
object BatchListIncomingTypedLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse =
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse(
        linkSpecifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def linkSpecifiers
        : Option[List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLinkSpecifiers: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ]] = AwsError.unwrapOptionField("linkSpecifiers", linkSpecifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse
  ) extends zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly {
    override val linkSpecifiers: Option[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ] = scala
      .Option(impl.linkSpecifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIncomingTypedLinksResponse
  ): zio.aws.clouddirectory.model.BatchListIncomingTypedLinksResponse.ReadOnly =
    new Wrapper(impl)
}
