package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchAttachPolicy(
    policyReference: zio.aws.clouddirectory.model.ObjectReference,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy = {
    import BatchAttachPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy
      .builder()
      .policyReference(policyReference.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachPolicy.wrap(buildAwsValue())
}
object BatchAttachPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachPolicy =
      zio.aws.clouddirectory.model.BatchAttachPolicy(
        policyReference.asEditable,
        objectReference.asEditable
      )
    def policyReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(policyReference)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy
  ) extends zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly {
    override val policyReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.policyReference())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy
  ): zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly = new Wrapper(impl)
}
