package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NextToken, NumberResults, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIndexRequest(
    directoryArn: Arn,
    rangesOnIndexedValues: Option[
      Iterable[zio.aws.clouddirectory.model.ObjectAttributeRange]
    ] = None,
    indexReference: zio.aws.clouddirectory.model.ObjectReference,
    maxResults: Option[NumberResults] = None,
    nextToken: Option[NextToken] = None,
    consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest = {
    import ListIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .optionallyWith(
        rangesOnIndexedValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rangesOnIndexedValues)
      .indexReference(indexReference.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ListIndexRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListIndexRequest.wrap(buildAwsValue())
}
object ListIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListIndexRequest =
      zio.aws.clouddirectory.model.ListIndexRequest(
        directoryArn,
        rangesOnIndexedValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        indexReference.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value),
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def rangesOnIndexedValues: Option[
      List[zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly]
    ]
    def indexReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def maxResults: Option[NumberResults]
    def nextToken: Option[NextToken]
    def consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getRangesOnIndexedValues: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly
    ]] =
      AwsError.unwrapOptionField("rangesOnIndexedValues", rangesOnIndexedValues)
    def getIndexReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(indexReference)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest
  ) extends zio.aws.clouddirectory.model.ListIndexRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val rangesOnIndexedValues: Option[
      List[zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly]
    ] = scala
      .Option(impl.rangesOnIndexedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.ObjectAttributeRange.wrap(item)
        }.toList
      )
    override val indexReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.indexReference())
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val consistencyLevel
        : Option[zio.aws.clouddirectory.model.ConsistencyLevel] = scala
      .Option(impl.consistencyLevel())
      .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest
  ): zio.aws.clouddirectory.model.ListIndexRequest.ReadOnly = new Wrapper(impl)
}
