package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchReadOperationResponse(
    successfulResponse: Option[
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse
    ] = None,
    exceptionResponse: Option[zio.aws.clouddirectory.model.BatchReadException] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse = {
    import BatchReadOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse
      .builder()
      .optionallyWith(successfulResponse.map(value => value.buildAwsValue()))(
        _.successfulResponse
      )
      .optionallyWith(exceptionResponse.map(value => value.buildAwsValue()))(
        _.exceptionResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadOperationResponse
      .wrap(buildAwsValue())
}
object BatchReadOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadOperationResponse =
      zio.aws.clouddirectory.model.BatchReadOperationResponse(
        successfulResponse.map(value => value.asEditable),
        exceptionResponse.map(value => value.asEditable)
      )
    def successfulResponse: Option[
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly
    ]
    def exceptionResponse
        : Option[zio.aws.clouddirectory.model.BatchReadException.ReadOnly]
    def getSuccessfulResponse: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly
    ] = AwsError.unwrapOptionField("successfulResponse", successfulResponse)
    def getExceptionResponse: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchReadException.ReadOnly
    ] = AwsError.unwrapOptionField("exceptionResponse", exceptionResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse
  ) extends zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly {
    override val successfulResponse: Option[
      zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.ReadOnly
    ] = scala
      .Option(impl.successfulResponse())
      .map(value =>
        zio.aws.clouddirectory.model.BatchReadSuccessfulResponse.wrap(value)
      )
    override val exceptionResponse
        : Option[zio.aws.clouddirectory.model.BatchReadException.ReadOnly] =
      scala
        .Option(impl.exceptionResponse())
        .map(value =>
          zio.aws.clouddirectory.model.BatchReadException.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse
  ): zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly =
    new Wrapper(impl)
}
