package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LinkAttributeAction(
    attributeActionType: Option[zio.aws.clouddirectory.model.UpdateActionType] =
      None,
    attributeUpdateValue: Option[
      zio.aws.clouddirectory.model.TypedAttributeValue
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction = {
    import LinkAttributeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction
      .builder()
      .optionallyWith(attributeActionType.map(value => value.unwrap))(
        _.attributeActionType
      )
      .optionallyWith(attributeUpdateValue.map(value => value.buildAwsValue()))(
        _.attributeUpdateValue
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly =
    zio.aws.clouddirectory.model.LinkAttributeAction.wrap(buildAwsValue())
}
object LinkAttributeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.LinkAttributeAction =
      zio.aws.clouddirectory.model.LinkAttributeAction(
        attributeActionType.map(value => value),
        attributeUpdateValue.map(value => value.asEditable)
      )
    def attributeActionType
        : Option[zio.aws.clouddirectory.model.UpdateActionType]
    def attributeUpdateValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def getAttributeActionType
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.UpdateActionType] =
      AwsError.unwrapOptionField("attributeActionType", attributeActionType)
    def getAttributeUpdateValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("attributeUpdateValue", attributeUpdateValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction
  ) extends zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly {
    override val attributeActionType
        : Option[zio.aws.clouddirectory.model.UpdateActionType] = scala
      .Option(impl.attributeActionType())
      .map(value => zio.aws.clouddirectory.model.UpdateActionType.wrap(value))
    override val attributeUpdateValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      scala
        .Option(impl.attributeUpdateValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.LinkAttributeAction
  ): zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly = new Wrapper(
    impl
  )
}
