package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTypedLinkFacetInformationResponse(
    identityAttributeOrder: Option[Iterable[AttributeName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse = {
    import GetTypedLinkFacetInformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse
      .builder()
      .optionallyWith(
        identityAttributeOrder.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.identityAttributeOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse
      .wrap(buildAwsValue())
}
object GetTypedLinkFacetInformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse =
      zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse(
        identityAttributeOrder.map(value => value)
      )
    def identityAttributeOrder: Option[List[AttributeName]]
    def getIdentityAttributeOrder: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField(
        "identityAttributeOrder",
        identityAttributeOrder
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse
  ) extends zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly {
    override val identityAttributeOrder: Option[List[AttributeName]] = scala
      .Option(impl.identityAttributeOrder())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.AttributeName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse
  ): zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly =
    new Wrapper(impl)
}
