package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchReadOperation(
    listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributes
    ] = None,
    listObjectChildren: Option[
      zio.aws.clouddirectory.model.BatchListObjectChildren
    ] = None,
    listAttachedIndices: Option[
      zio.aws.clouddirectory.model.BatchListAttachedIndices
    ] = None,
    listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths
    ] = None,
    getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformation
    ] = None,
    getObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetObjectAttributes
    ] = None,
    listObjectParents: Option[
      zio.aws.clouddirectory.model.BatchListObjectParents
    ] = None,
    listObjectPolicies: Option[
      zio.aws.clouddirectory.model.BatchListObjectPolicies
    ] = None,
    listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments
    ] = None,
    lookupPolicy: Option[zio.aws.clouddirectory.model.BatchLookupPolicy] = None,
    listIndex: Option[zio.aws.clouddirectory.model.BatchListIndex] = None,
    listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks
    ] = None,
    listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks
    ] = None,
    getLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetLinkAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation = {
    import BatchReadOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
      .builder()
      .optionallyWith(listObjectAttributes.map(value => value.buildAwsValue()))(
        _.listObjectAttributes
      )
      .optionallyWith(listObjectChildren.map(value => value.buildAwsValue()))(
        _.listObjectChildren
      )
      .optionallyWith(listAttachedIndices.map(value => value.buildAwsValue()))(
        _.listAttachedIndices
      )
      .optionallyWith(
        listObjectParentPaths.map(value => value.buildAwsValue())
      )(_.listObjectParentPaths)
      .optionallyWith(getObjectInformation.map(value => value.buildAwsValue()))(
        _.getObjectInformation
      )
      .optionallyWith(getObjectAttributes.map(value => value.buildAwsValue()))(
        _.getObjectAttributes
      )
      .optionallyWith(listObjectParents.map(value => value.buildAwsValue()))(
        _.listObjectParents
      )
      .optionallyWith(listObjectPolicies.map(value => value.buildAwsValue()))(
        _.listObjectPolicies
      )
      .optionallyWith(
        listPolicyAttachments.map(value => value.buildAwsValue())
      )(_.listPolicyAttachments)
      .optionallyWith(lookupPolicy.map(value => value.buildAwsValue()))(
        _.lookupPolicy
      )
      .optionallyWith(listIndex.map(value => value.buildAwsValue()))(
        _.listIndex
      )
      .optionallyWith(
        listOutgoingTypedLinks.map(value => value.buildAwsValue())
      )(_.listOutgoingTypedLinks)
      .optionallyWith(
        listIncomingTypedLinks.map(value => value.buildAwsValue())
      )(_.listIncomingTypedLinks)
      .optionallyWith(getLinkAttributes.map(value => value.buildAwsValue()))(
        _.getLinkAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadOperation.wrap(buildAwsValue())
}
object BatchReadOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadOperation =
      zio.aws.clouddirectory.model.BatchReadOperation(
        listObjectAttributes.map(value => value.asEditable),
        listObjectChildren.map(value => value.asEditable),
        listAttachedIndices.map(value => value.asEditable),
        listObjectParentPaths.map(value => value.asEditable),
        getObjectInformation.map(value => value.asEditable),
        getObjectAttributes.map(value => value.asEditable),
        listObjectParents.map(value => value.asEditable),
        listObjectPolicies.map(value => value.asEditable),
        listPolicyAttachments.map(value => value.asEditable),
        lookupPolicy.map(value => value.asEditable),
        listIndex.map(value => value.asEditable),
        listOutgoingTypedLinks.map(value => value.asEditable),
        listIncomingTypedLinks.map(value => value.asEditable),
        getLinkAttributes.map(value => value.asEditable)
      )
    def listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ]
    def listObjectChildren
        : Option[zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly]
    def listAttachedIndices
        : Option[zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly]
    def listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ]
    def getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ]
    def getObjectAttributes
        : Option[zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly]
    def listObjectParents
        : Option[zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly]
    def listObjectPolicies
        : Option[zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly]
    def listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ]
    def lookupPolicy
        : Option[zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly]
    def listIndex: Option[zio.aws.clouddirectory.model.BatchListIndex.ReadOnly]
    def listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ]
    def listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ]
    def getLinkAttributes
        : Option[zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly]
    def getListObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectAttributes", listObjectAttributes)
    def getListObjectChildren: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectChildren", listObjectChildren)
    def getListAttachedIndices: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly
    ] = AwsError.unwrapOptionField("listAttachedIndices", listAttachedIndices)
    def getListObjectParentPaths: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ] =
      AwsError.unwrapOptionField("listObjectParentPaths", listObjectParentPaths)
    def getGetObjectInformation: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectInformation", getObjectInformation)
    def getGetObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("getObjectAttributes", getObjectAttributes)
    def getListObjectParents: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectParents", listObjectParents)
    def getListObjectPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("listObjectPolicies", listObjectPolicies)
    def getListPolicyAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ] =
      AwsError.unwrapOptionField("listPolicyAttachments", listPolicyAttachments)
    def getLookupPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("lookupPolicy", lookupPolicy)
    def getListIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIndex.ReadOnly
    ] = AwsError.unwrapOptionField("listIndex", listIndex)
    def getListOutgoingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listOutgoingTypedLinks",
      listOutgoingTypedLinks
    )
    def getListIncomingTypedLinks: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ] = AwsError.unwrapOptionField(
      "listIncomingTypedLinks",
      listIncomingTypedLinks
    )
    def getGetLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("getLinkAttributes", getLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ) extends zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly {
    override val listObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly
    ] = scala
      .Option(impl.listObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectAttributes.wrap(value)
      )
    override val listObjectChildren: Option[
      zio.aws.clouddirectory.model.BatchListObjectChildren.ReadOnly
    ] = scala
      .Option(impl.listObjectChildren())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectChildren.wrap(value)
      )
    override val listAttachedIndices: Option[
      zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly
    ] = scala
      .Option(impl.listAttachedIndices())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListAttachedIndices.wrap(value)
      )
    override val listObjectParentPaths: Option[
      zio.aws.clouddirectory.model.BatchListObjectParentPaths.ReadOnly
    ] = scala
      .Option(impl.listObjectParentPaths())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectParentPaths.wrap(value)
      )
    override val getObjectInformation: Option[
      zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly
    ] = scala
      .Option(impl.getObjectInformation())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectInformation.wrap(value)
      )
    override val getObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly
    ] = scala
      .Option(impl.getObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchGetObjectAttributes.wrap(value)
      )
    override val listObjectParents
        : Option[zio.aws.clouddirectory.model.BatchListObjectParents.ReadOnly] =
      scala
        .Option(impl.listObjectParents())
        .map(value =>
          zio.aws.clouddirectory.model.BatchListObjectParents.wrap(value)
        )
    override val listObjectPolicies: Option[
      zio.aws.clouddirectory.model.BatchListObjectPolicies.ReadOnly
    ] = scala
      .Option(impl.listObjectPolicies())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListObjectPolicies.wrap(value)
      )
    override val listPolicyAttachments: Option[
      zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly
    ] = scala
      .Option(impl.listPolicyAttachments())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListPolicyAttachments.wrap(value)
      )
    override val lookupPolicy
        : Option[zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly] =
      scala
        .Option(impl.lookupPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchLookupPolicy.wrap(value)
        )
    override val listIndex
        : Option[zio.aws.clouddirectory.model.BatchListIndex.ReadOnly] = scala
      .Option(impl.listIndex())
      .map(value => zio.aws.clouddirectory.model.BatchListIndex.wrap(value))
    override val listOutgoingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly
    ] = scala
      .Option(impl.listOutgoingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.wrap(value)
      )
    override val listIncomingTypedLinks: Option[
      zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.ReadOnly
    ] = scala
      .Option(impl.listIncomingTypedLinks())
      .map(value =>
        zio.aws.clouddirectory.model.BatchListIncomingTypedLinks.wrap(value)
      )
    override val getLinkAttributes
        : Option[zio.aws.clouddirectory.model.BatchGetLinkAttributes.ReadOnly] =
      scala
        .Option(impl.getLinkAttributes())
        .map(value =>
          zio.aws.clouddirectory.model.BatchGetLinkAttributes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation
  ): zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly = new Wrapper(
    impl
  )
}
