package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ExceptionMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchReadException(
    `type`: Option[zio.aws.clouddirectory.model.BatchReadExceptionType] = None,
    message: Option[ExceptionMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadException = {
    import BatchReadException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadException
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        message.map(value => ExceptionMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchReadException.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadException.wrap(buildAwsValue())
}
object BatchReadException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadException =
      zio.aws.clouddirectory.model.BatchReadException(
        `type`.map(value => value),
        message.map(value => value)
      )
    def `type`: Option[zio.aws.clouddirectory.model.BatchReadExceptionType]
    def message: Option[ExceptionMessage]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchReadExceptionType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMessage: ZIO[Any, AwsError, ExceptionMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadException
  ) extends zio.aws.clouddirectory.model.BatchReadException.ReadOnly {
    override val `type`
        : Option[zio.aws.clouddirectory.model.BatchReadExceptionType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.clouddirectory.model.BatchReadExceptionType.wrap(value)
      )
    override val message: Option[ExceptionMessage] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ExceptionMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadException
  ): zio.aws.clouddirectory.model.BatchReadException.ReadOnly = new Wrapper(
    impl
  )
}
