package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachToIndexRequest(
    directoryArn: Arn,
    indexReference: zio.aws.clouddirectory.model.ObjectReference,
    targetReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest = {
    import AttachToIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .indexReference(indexReference.buildAwsValue())
      .targetReference(targetReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachToIndexRequest.ReadOnly =
    zio.aws.clouddirectory.model.AttachToIndexRequest.wrap(buildAwsValue())
}
object AttachToIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachToIndexRequest =
      zio.aws.clouddirectory.model.AttachToIndexRequest(
        directoryArn,
        indexReference.asEditable,
        targetReference.asEditable
      )
    def directoryArn: Arn
    def indexReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def targetReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getIndexReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(indexReference)
    def getTargetReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest
  ) extends zio.aws.clouddirectory.model.AttachToIndexRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val indexReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.indexReference())
    override val targetReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.targetReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest
  ): zio.aws.clouddirectory.model.AttachToIndexRequest.ReadOnly = new Wrapper(
    impl
  )
}
