package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublishSchemaResponse(publishedSchemaArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse = {
    import PublishSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse
      .builder()
      .optionallyWith(
        publishedSchemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.publishedSchemaArn)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.PublishSchemaResponse.wrap(buildAwsValue())
}
object PublishSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PublishSchemaResponse =
      zio.aws.clouddirectory.model
        .PublishSchemaResponse(publishedSchemaArn.map(value => value))
    def publishedSchemaArn: Option[Arn]
    def getPublishedSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("publishedSchemaArn", publishedSchemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse
  ) extends zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly {
    override val publishedSchemaArn: Option[Arn] = scala
      .Option(impl.publishedSchemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse
  ): zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
