package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAppliedSchemaVersionResponse(
    appliedSchemaArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse = {
    import GetAppliedSchemaVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse
      .builder()
      .optionallyWith(
        appliedSchemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appliedSchemaArn)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse
      .wrap(buildAwsValue())
}
object GetAppliedSchemaVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse =
      zio.aws.clouddirectory.model
        .GetAppliedSchemaVersionResponse(appliedSchemaArn.map(value => value))
    def appliedSchemaArn: Option[Arn]
    def getAppliedSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appliedSchemaArn", appliedSchemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse
  ) extends zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly {
    override val appliedSchemaArn: Option[Arn] = scala
      .Option(impl.appliedSchemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse
  ): zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly =
    new Wrapper(impl)
}
