package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSchemaResponse(schemaArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse = {
    import CreateSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.CreateSchemaResponse.wrap(buildAwsValue())
}
object CreateSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateSchemaResponse =
      zio.aws.clouddirectory.model
        .CreateSchemaResponse(schemaArn.map(value => value))
    def schemaArn: Option[Arn]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse
  ) extends zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly {
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse
  ): zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
