package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDetachObjectResponse(
    detachedObjectIdentifier: Option[ObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse = {
    import BatchDetachObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse
      .builder()
      .optionallyWith(
        detachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.detachedObjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachObjectResponse.wrap(buildAwsValue())
}
object BatchDetachObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachObjectResponse =
      zio.aws.clouddirectory.model
        .BatchDetachObjectResponse(detachedObjectIdentifier.map(value => value))
    def detachedObjectIdentifier: Option[ObjectIdentifier]
    def getDetachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "detachedObjectIdentifier",
        detachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse
  ) extends zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly {
    override val detachedObjectIdentifier: Option[ObjectIdentifier] = scala
      .Option(impl.detachedObjectIdentifier())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse
  ): zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly =
    new Wrapper(impl)
}
