package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListObjectAttributesResponse(
    attributes: Option[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse = {
    import ListObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectAttributesResponse
      .wrap(buildAwsValue())
}
object ListObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectAttributesResponse =
      zio.aws.clouddirectory.model.ListObjectAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributes: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse
  ) extends zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly {
    override val attributes: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse
  ): zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
