package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchReadResponse(
    responses: Optional[
      Iterable[zio.aws.clouddirectory.model.BatchReadOperationResponse]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse = {
    import BatchReadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadResponse.wrap(buildAwsValue())
}
object BatchReadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadResponse =
      zio.aws.clouddirectory.model.BatchReadResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses: Optional[
      List[zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly]
    ]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse
  ) extends zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly {
    override val responses: Optional[
      List[zio.aws.clouddirectory.model.BatchReadOperationResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.BatchReadOperationResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse
  ): zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly = new Wrapper(impl)
}
