package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{SchemaName, Version, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishSchemaRequest(
    developmentSchemaArn: Arn,
    version: Version,
    minorVersion: Optional[Version] = Optional.Absent,
    name: Optional[SchemaName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest = {
    import PublishSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest
      .builder()
      .developmentSchemaArn(Arn.unwrap(developmentSchemaArn): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .optionallyWith(
        minorVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.minorVersion)
      .optionallyWith(
        name.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.PublishSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.PublishSchemaRequest.wrap(buildAwsValue())
}
object PublishSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PublishSchemaRequest =
      zio.aws.clouddirectory.model.PublishSchemaRequest(
        developmentSchemaArn,
        version,
        minorVersion.map(value => value),
        name.map(value => value)
      )
    def developmentSchemaArn: Arn
    def version: Version
    def minorVersion: Optional[Version]
    def name: Optional[SchemaName]
    def getDevelopmentSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(developmentSchemaArn)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getMinorVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("minorVersion", minorVersion)
    def getName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest
  ) extends zio.aws.clouddirectory.model.PublishSchemaRequest.ReadOnly {
    override val developmentSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.developmentSchemaArn())
    override val version: Version =
      zio.aws.clouddirectory.model.primitives.Version(impl.version())
    override val minorVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.minorVersion())
      .map(value => zio.aws.clouddirectory.model.primitives.Version(value))
    override val name: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.clouddirectory.model.primitives.SchemaName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest
  ): zio.aws.clouddirectory.model.PublishSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
