package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSchemaRequest(schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest = {
    import DeleteSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DeleteSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.DeleteSchemaRequest.wrap(buildAwsValue())
}
object DeleteSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteSchemaRequest =
      zio.aws.clouddirectory.model.DeleteSchemaRequest(schemaArn)
    def schemaArn: Arn
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest
  ) extends zio.aws.clouddirectory.model.DeleteSchemaRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest
  ): zio.aws.clouddirectory.model.DeleteSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
