package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.LinkName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchAttachObject(
    parentReference: zio.aws.clouddirectory.model.ObjectReference,
    childReference: zio.aws.clouddirectory.model.ObjectReference,
    linkName: LinkName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject = {
    import BatchAttachObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject
      .builder()
      .parentReference(parentReference.buildAwsValue())
      .childReference(childReference.buildAwsValue())
      .linkName(LinkName.unwrap(linkName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchAttachObject.wrap(buildAwsValue())
}
object BatchAttachObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchAttachObject =
      zio.aws.clouddirectory.model.BatchAttachObject(
        parentReference.asEditable,
        childReference.asEditable,
        linkName
      )
    def parentReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def childReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def linkName: LinkName
    def getParentReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(parentReference)
    def getChildReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(childReference)
    def getLinkName: ZIO[Any, Nothing, LinkName] = ZIO.succeed(linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject
  ) extends zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly {
    override val parentReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.parentReference())
    override val childReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.childReference())
    override val linkName: LinkName =
      zio.aws.clouddirectory.model.primitives.LinkName(impl.linkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject
  ): zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly = new Wrapper(impl)
}
