package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDirectoryRequest(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest = {
    import DeleteDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DeleteDirectoryRequest.ReadOnly =
    zio.aws.clouddirectory.model.DeleteDirectoryRequest.wrap(buildAwsValue())
}
object DeleteDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteDirectoryRequest =
      zio.aws.clouddirectory.model.DeleteDirectoryRequest(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest
  ) extends zio.aws.clouddirectory.model.DeleteDirectoryRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest
  ): zio.aws.clouddirectory.model.DeleteDirectoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
