package zio.aws.cloudcontrol.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelResourceRequestResponse(
    progressEvent: Optional[zio.aws.cloudcontrol.model.ProgressEvent] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse = {
    import CancelResourceRequestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse
      .builder()
      .optionallyWith(progressEvent.map(value => value.buildAwsValue()))(
        _.progressEvent
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly =
    zio.aws.cloudcontrol.model.CancelResourceRequestResponse
      .wrap(buildAwsValue())
}
object CancelResourceRequestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.CancelResourceRequestResponse =
      zio.aws.cloudcontrol.model.CancelResourceRequestResponse(
        progressEvent.map(value => value.asEditable)
      )
    def progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly]
    def getProgressEvent: ZIO[
      Any,
      AwsError,
      zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly
    ] = AwsError.unwrapOptionField("progressEvent", progressEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse
  ) extends zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly {
    override val progressEvent
        : Optional[zio.aws.cloudcontrol.model.ProgressEvent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressEvent())
        .map(value => zio.aws.cloudcontrol.model.ProgressEvent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse
  ): zio.aws.cloudcontrol.model.CancelResourceRequestResponse.ReadOnly =
    new Wrapper(impl)
}
