package zio.aws.cloudcontrol.model
import scala.jdk.CollectionConverters.*
sealed trait Operation {
  def unwrap: software.amazon.awssdk.services.cloudcontrol.model.Operation
}
object Operation {
  def wrap(
      value: software.amazon.awssdk.services.cloudcontrol.model.Operation
  ): zio.aws.cloudcontrol.model.Operation = value match {
    case software.amazon.awssdk.services.cloudcontrol.model.Operation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudcontrol.model.Operation.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.cloudcontrol.model.Operation.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.cloudcontrol.model.Operation.UPDATE =>
      val r = UPDATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudcontrol.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.Operation =
      software.amazon.awssdk.services.cloudcontrol.model.Operation.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.cloudcontrol.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.Operation =
      software.amazon.awssdk.services.cloudcontrol.model.Operation.CREATE
  }
  case object DELETE extends zio.aws.cloudcontrol.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.Operation =
      software.amazon.awssdk.services.cloudcontrol.model.Operation.DELETE
  }
  case object UPDATE extends zio.aws.cloudcontrol.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.Operation =
      software.amazon.awssdk.services.cloudcontrol.model.Operation.UPDATE
  }
}
