package zio.aws.cloudcontrol.model
import zio.aws.cloudcontrol.model.primitives.{
  Identifier,
  RoleArn,
  TypeVersionId,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetResourceRequest(
    typeName: TypeName,
    typeVersionId: Option[TypeVersionId] = None,
    roleArn: Option[RoleArn] = None,
    identifier: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest = {
    import GetResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest
      .builder()
      .typeName(TypeName.unwrap(typeName): java.lang.String)
      .optionallyWith(
        typeVersionId.map(value =>
          TypeVersionId.unwrap(value): java.lang.String
        )
      )(_.typeVersionId)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudcontrol.model.GetResourceRequest.ReadOnly =
    zio.aws.cloudcontrol.model.GetResourceRequest.wrap(buildAwsValue())
}
object GetResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudcontrol.model.GetResourceRequest =
      zio.aws.cloudcontrol.model.GetResourceRequest(
        typeName,
        typeVersionId.map(value => value),
        roleArn.map(value => value),
        identifier
      )
    def typeName: TypeName
    def typeVersionId: Option[TypeVersionId]
    def roleArn: Option[RoleArn]
    def identifier: Identifier
    def getTypeName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(typeName)
    def getTypeVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("typeVersionId", typeVersionId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest
  ) extends zio.aws.cloudcontrol.model.GetResourceRequest.ReadOnly {
    override val typeName: TypeName =
      zio.aws.cloudcontrol.model.primitives.TypeName(impl.typeName())
    override val typeVersionId: Option[TypeVersionId] = scala
      .Option(impl.typeVersionId())
      .map(value => zio.aws.cloudcontrol.model.primitives.TypeVersionId(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.cloudcontrol.model.primitives.RoleArn(value))
    override val identifier: Identifier =
      zio.aws.cloudcontrol.model.primitives.Identifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest
  ): zio.aws.cloudcontrol.model.GetResourceRequest.ReadOnly = new Wrapper(impl)
}
